/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.openal.sound3d;

import com.jogamp.openal.AL;
import com.jogamp.openal.sound3d.Buffer;
import com.jogamp.openal.sound3d.Vec3f;

public final class Source {
    private final AL al;
    private final int sourceID;
    private Buffer buffer;

    Source(AL aL, int n2) {
        this.al = aL;
        this.sourceID = n2;
    }

    public void play() {
        this.al.alSourcePlay(this.sourceID);
    }

    public void pause() {
        this.al.alSourcePause(this.sourceID);
    }

    public void stop() {
        this.al.alSourceStop(this.sourceID);
    }

    public void rewind() {
        this.al.alSourceRewind(this.sourceID);
    }

    public void delete() {
        this.al.alDeleteSources(1, new int[]{this.sourceID}, 0);
    }

    public boolean isPlaying() {
        int[] nArray = new int[1];
        this.al.alGetSourcei(this.sourceID, 4112, nArray, 0);
        return nArray[0] == 4114;
    }

    public void setPitch(float f2) {
        this.al.alSourcef(this.sourceID, 4099, f2);
    }

    public float getPitch() {
        float[] fArray = new float[1];
        this.al.alGetSourcef(this.sourceID, 4099, fArray, 0);
        return fArray[0];
    }

    public void setGain(float f2) {
        this.al.alSourcef(this.sourceID, 4106, f2);
    }

    public float getGain() {
        float[] fArray = new float[1];
        this.al.alGetSourcef(this.sourceID, 4106, fArray, 0);
        return fArray[0];
    }

    public void setMaxDistance(float f2) {
        this.al.alSourcef(this.sourceID, 4131, f2);
    }

    public float getMaxDistance() {
        float[] fArray = new float[1];
        this.al.alGetSourcef(this.sourceID, 4131, fArray, 0);
        return fArray[0];
    }

    public void setRolloffFactor(float f2) {
        this.al.alSourcef(this.sourceID, 4129, f2);
    }

    public float getRolloffFactor() {
        float[] fArray = new float[1];
        this.al.alGetSourcef(this.sourceID, 4129, fArray, 0);
        return fArray[0];
    }

    public void setReferenceDistance(float f2) {
        this.al.alSourcef(this.sourceID, 4128, f2);
    }

    public float getReferenceDistance() {
        float[] fArray = new float[1];
        this.al.alGetSourcef(this.sourceID, 4128, fArray, 0);
        return fArray[0];
    }

    public void setMinGain(float f2) {
        this.al.alSourcef(this.sourceID, 4109, f2);
    }

    public float getMinGain() {
        float[] fArray = new float[1];
        this.al.alGetSourcef(this.sourceID, 4109, fArray, 0);
        return fArray[0];
    }

    public void setMaxGain(float f2) {
        this.al.alSourcef(this.sourceID, 4110, f2);
    }

    public float getMaxGain() {
        float[] fArray = new float[1];
        this.al.alGetSourcef(this.sourceID, 4110, fArray, 0);
        return fArray[0];
    }

    public void setConeOuterGain(float f2) {
        this.al.alSourcef(this.sourceID, 4130, f2);
    }

    public float getConeOuterGain() {
        float[] fArray = new float[1];
        this.al.alGetSourcef(this.sourceID, 4130, fArray, 0);
        return fArray[0];
    }

    public void setPosition(Vec3f vec3f) {
        this.al.alSource3f(this.sourceID, 4100, vec3f.v1, vec3f.v2, vec3f.v3);
    }

    public void setPosition(float f2, float f3, float f4) {
        this.al.alSource3f(this.sourceID, 4100, f2, f3, f4);
    }

    public Vec3f getPosition() {
        Vec3f vec3f = null;
        float[] fArray = new float[3];
        this.al.alGetSourcefv(this.sourceID, 4100, fArray, 0);
        vec3f = new Vec3f(fArray[0], fArray[1], fArray[2]);
        return vec3f;
    }

    public void setVelocity(Vec3f vec3f) {
        this.al.alSource3f(this.sourceID, 4102, vec3f.v1, vec3f.v2, vec3f.v3);
    }

    public void setVelocity(float f2, float f3, float f4) {
        this.al.alSource3f(this.sourceID, 4102, f2, f3, f4);
    }

    public Vec3f getVelocity() {
        Vec3f vec3f = null;
        float[] fArray = new float[3];
        this.al.alGetSourcefv(this.sourceID, 4102, fArray, 0);
        vec3f = new Vec3f(fArray[0], fArray[1], fArray[2]);
        return vec3f;
    }

    public void setDirection(Vec3f vec3f) {
        this.al.alSource3f(this.sourceID, 4101, vec3f.v1, vec3f.v2, vec3f.v3);
    }

    public void setDirection(float f2, float f3, float f4) {
        this.al.alSource3f(this.sourceID, 4101, f2, f3, f4);
    }

    public Vec3f getDirection() {
        Vec3f vec3f = null;
        float[] fArray = new float[3];
        this.al.alGetSourcefv(this.sourceID, 4101, fArray, 0);
        vec3f = new Vec3f(fArray[0], fArray[1], fArray[2]);
        return vec3f;
    }

    public void setSourceRelative(boolean bl) {
        int n2 = bl ? 1 : 0;
        this.al.alSourcei(this.sourceID, 514, n2);
    }

    public boolean isSourceRelative() {
        int[] nArray = new int[1];
        this.al.alGetSourcei(this.sourceID, 514, nArray, 0);
        return nArray[0] == 1;
    }

    public void setLooping(boolean bl) {
        int n2 = bl ? 1 : 0;
        this.al.alSourcei(this.sourceID, 4103, n2);
    }

    public boolean getLooping() {
        int[] nArray = new int[1];
        this.al.alGetSourcei(this.sourceID, 4103, nArray, 0);
        return nArray[0] == 1;
    }

    public int getBuffersQueued() {
        int[] nArray = new int[1];
        this.al.alGetSourcei(this.sourceID, 4117, nArray, 0);
        return nArray[0];
    }

    public int getBuffersProcessed() {
        int[] nArray = new int[1];
        this.al.alGetSourcei(this.sourceID, 4118, nArray, 0);
        return nArray[0];
    }

    public void setBuffer(Buffer buffer) {
        this.al.alSourcei(this.sourceID, 4105, buffer.bufferID);
        this.buffer = buffer;
    }

    public Buffer getBuffer() {
        return this.buffer;
    }

    public void queueBuffers(Buffer[] bufferArray) {
        int n2 = bufferArray.length;
        int[] nArray = new int[n2];
        for (int i2 = 0; i2 < n2; ++i2) {
            nArray[i2] = bufferArray[i2].bufferID;
        }
        this.al.alSourceQueueBuffers(this.sourceID, n2, nArray, 0);
    }

    public void unqueueBuffers(Buffer[] bufferArray) {
        int n2 = bufferArray.length;
        int[] nArray = new int[n2];
        for (int i2 = 0; i2 < n2; ++i2) {
            nArray[i2] = bufferArray[i2].bufferID;
        }
        this.al.alSourceUnqueueBuffers(this.sourceID, n2, nArray, 0);
    }
}

