/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.nativewindow.x11;

import com.jogamp.nativewindow.DefaultGraphicsDevice;
import com.jogamp.nativewindow.NativeWindowException;
import com.jogamp.nativewindow.NativeWindowFactory;
import com.jogamp.nativewindow.ToolkitLock;
import jogamp.nativewindow.x11.X11Lib;
import jogamp.nativewindow.x11.X11Util;

public class X11GraphicsDevice
extends DefaultGraphicsDevice
implements Cloneable {
    boolean handleOwner;
    final boolean isXineramaEnabled;

    public X11GraphicsDevice(String string, int n2) {
        super(".x11", string, n2);
        this.handleOwner = false;
        this.isXineramaEnabled = false;
    }

    public X11GraphicsDevice(long l2, int n2, boolean bl) {
        this(l2, n2, NativeWindowFactory.getDefaultToolkitLock(".x11", l2), bl);
    }

    public X11GraphicsDevice(long l2, int n2, ToolkitLock toolkitLock, boolean bl) {
        super(".x11", X11Lib.XDisplayString(l2), n2, l2, toolkitLock);
        if (0L == l2) {
            throw new NativeWindowException("null display");
        }
        this.handleOwner = bl;
        this.isXineramaEnabled = X11Util.XineramaIsEnabled(this);
    }

    public X11GraphicsDevice(String string, int n2, ToolkitLock toolkitLock) {
        super(".x11", string, n2, 0L, toolkitLock);
        this.handleOwner = true;
        this.open();
        this.isXineramaEnabled = X11Util.XineramaIsEnabled(this);
    }

    private static int getDefaultScreenImpl(long l2) {
        return X11Lib.DefaultScreen(l2);
    }

    public int getDefaultScreen() {
        long l2 = this.getHandle();
        if (0L == l2) {
            throw new NativeWindowException("null display");
        }
        int n2 = X11GraphicsDevice.getDefaultScreenImpl(l2);
        if (DEBUG) {
            System.err.println(Thread.currentThread().getName() + " - X11GraphicsDevice.getDefaultDisplay() of " + this + ": " + n2 + ", count " + X11Lib.ScreenCount(l2));
        }
        return n2;
    }

    public int getDefaultVisualID() {
        long l2 = this.getHandle();
        if (0L == l2) {
            throw new NativeWindowException("null display");
        }
        return X11Lib.DefaultVisualID(l2, X11GraphicsDevice.getDefaultScreenImpl(l2));
    }

    public final boolean isXineramaEnabled() {
        return this.isXineramaEnabled;
    }

    @Override
    public Object clone() {
        return super.clone();
    }

    @Override
    public boolean open() {
        if (this.handleOwner && 0L == this.handle) {
            if (DEBUG) {
                System.err.println(Thread.currentThread().getName() + " - X11GraphicsDevice.open(): " + this);
            }
            this.handle = X11Util.openDisplay(this.connection);
            if (0L == this.handle) {
                throw new NativeWindowException("X11GraphicsDevice.open() failed: " + this);
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean close() {
        if (this.handleOwner && 0L != this.handle) {
            if (DEBUG) {
                System.err.println(Thread.currentThread().getName() + " - X11GraphicsDevice.close(): " + this);
            }
            X11Util.closeDisplay(this.handle);
        }
        return super.close();
    }

    @Override
    public boolean isHandleOwner() {
        return this.handleOwner;
    }

    @Override
    public void clearHandleOwner() {
        this.handleOwner = false;
    }

    @Override
    protected Object getHandleOwnership() {
        return this.handleOwner;
    }

    @Override
    protected Object setHandleOwnership(Object object) {
        Boolean bl = this.handleOwner;
        this.handleOwner = (Boolean)object;
        return bl;
    }
}

