/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.nativewindow.awt;

import com.jogamp.common.nio.Buffers;
import java.awt.Point;
import java.awt.color.ColorSpace;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.DataBuffer;
import java.awt.image.DirectColorModel;
import java.awt.image.SampleModel;
import java.awt.image.SinglePixelPackedSampleModel;
import java.awt.image.WritableRaster;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import java.util.Hashtable;

public final class DirectDataBufferInt
extends DataBuffer {
    private final ByteBuffer dataBytes;
    private final IntBuffer dataInts;
    private final ByteBuffer[] bankdataBytes;
    private final IntBuffer[] bankdataInts;

    public static BufferedImageInt createBufferedImage(int n2, int n3, int n4, Point point, Hashtable<?, ?> hashtable) {
        int[] nArray;
        boolean bl;
        int n5;
        int n6;
        int n7;
        int n8;
        int n9;
        ColorSpace colorSpace = ColorSpace.getInstance(1000);
        switch (n4) {
            case 2: {
                n9 = 32;
                n8 = 0xFF0000;
                n7 = 65280;
                n6 = 255;
                n5 = -16777216;
                bl = false;
                break;
            }
            case 3: {
                n9 = 32;
                n8 = 0xFF0000;
                n7 = 65280;
                n6 = 255;
                n5 = -16777216;
                bl = true;
                break;
            }
            case 1: {
                n9 = 24;
                n8 = 0xFF0000;
                n7 = 65280;
                n6 = 255;
                n5 = 0;
                bl = false;
                break;
            }
            case 4: {
                n9 = 24;
                n8 = 255;
                n7 = 65280;
                n6 = 0xFF0000;
                n5 = 0;
                bl = false;
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported imageType, must be [INT_ARGB, INT_ARGB_PRE, INT_RGB, INT_BGR], has " + n4);
            }
        }
        DirectColorModel directColorModel = new DirectColorModel(colorSpace, n9, n8, n7, n6, n5, bl, 3);
        if (0 != n5) {
            nArray = new int[4];
            nArray[3] = n5;
        } else {
            nArray = new int[]{n8, n7, n6};
        }
        DirectDataBufferInt directDataBufferInt = new DirectDataBufferInt(n2 * n3);
        if (null == point) {
            point = new Point(0, 0);
        }
        SinglePixelPackedSampleModel singlePixelPackedSampleModel = new SinglePixelPackedSampleModel(directDataBufferInt.getDataType(), n2, n3, n2, nArray);
        DirectWritableRaster directWritableRaster = new DirectWritableRaster((SampleModel)singlePixelPackedSampleModel, directDataBufferInt, point);
        return new BufferedImageInt(n4, directColorModel, directDataBufferInt, directWritableRaster, hashtable);
    }

    public DirectDataBufferInt(int n2) {
        super(3, n2);
        this.dataBytes = Buffers.newDirectByteBuffer(n2 * 4);
        this.dataInts = this.dataBytes.asIntBuffer();
        this.bankdataBytes = new ByteBuffer[1];
        this.bankdataInts = new IntBuffer[1];
        this.bankdataBytes[0] = this.dataBytes;
        this.bankdataInts[0] = this.dataInts;
    }

    public DirectDataBufferInt(int n2, int n3) {
        super(3, n2, n3);
        this.bankdataBytes = new ByteBuffer[n3];
        this.bankdataInts = new IntBuffer[n3];
        for (int i2 = 0; i2 < n3; ++i2) {
            this.bankdataBytes[i2] = Buffers.newDirectByteBuffer(n2 * 4);
            this.bankdataInts[i2] = this.bankdataBytes[i2].asIntBuffer();
        }
        this.dataBytes = this.bankdataBytes[0];
        this.dataInts = this.bankdataInts[0];
    }

    public DirectDataBufferInt(ByteBuffer byteBuffer, int n2) {
        super(3, n2);
        this.dataBytes = Buffers.nativeOrder(byteBuffer);
        this.dataInts = this.dataBytes.asIntBuffer();
        this.bankdataBytes = new ByteBuffer[1];
        this.bankdataInts = new IntBuffer[1];
        this.bankdataBytes[0] = this.dataBytes;
        this.bankdataInts[0] = this.dataInts;
    }

    public IntBuffer getData() {
        return this.dataInts;
    }

    public ByteBuffer getDataBytes() {
        return this.dataBytes;
    }

    public IntBuffer getData(int n2) {
        return this.bankdataInts[n2];
    }

    public ByteBuffer getDataBytes(int n2) {
        return this.bankdataBytes[n2];
    }

    @Override
    public int getElem(int n2) {
        return this.dataInts.get(n2 + this.offset);
    }

    @Override
    public int getElem(int n2, int n3) {
        return this.bankdataInts[n2].get(n3 + this.offsets[n2]);
    }

    @Override
    public void setElem(int n2, int n3) {
        this.dataInts.put(n2 + this.offset, n3);
    }

    @Override
    public void setElem(int n2, int n3, int n4) {
        this.bankdataInts[n2].put(n3 + this.offsets[n2], n4);
    }

    public static class DirectWritableRaster
    extends WritableRaster {
        protected DirectWritableRaster(SampleModel sampleModel, DirectDataBufferInt directDataBufferInt, Point point) {
            super(sampleModel, directDataBufferInt, point);
        }
    }

    public static class BufferedImageInt
    extends BufferedImage {
        final int customImageType;
        final DirectDataBufferInt dataBuffer;

        public BufferedImageInt(int n2, ColorModel colorModel, DirectDataBufferInt directDataBufferInt, WritableRaster writableRaster, Hashtable<?, ?> hashtable) {
            super(colorModel, writableRaster, false, hashtable);
            this.customImageType = n2;
            this.dataBuffer = directDataBufferInt;
        }

        public int getCustomType() {
            return this.customImageType;
        }

        public DirectDataBufferInt getDataBuffer() {
            return this.dataBuffer;
        }

        @Override
        public String toString() {
            return "BufferedImageInt@" + Integer.toHexString(this.hashCode()) + ": custom/internal type = " + this.customImageType + "/" + this.getType() + " " + this.getColorModel() + " " + this.getRaster();
        }
    }
}

