/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.nativewindow;

import com.jogamp.nativewindow.AbstractGraphicsConfiguration;
import com.jogamp.nativewindow.AbstractGraphicsScreen;
import com.jogamp.nativewindow.CapabilitiesImmutable;
import com.jogamp.nativewindow.NativeWindowException;
import com.jogamp.nativewindow.VisualIDHolder;
import jogamp.nativewindow.Debug;

public class DefaultGraphicsConfiguration
implements Cloneable,
AbstractGraphicsConfiguration {
    protected static final boolean DEBUG = Debug.debug("GraphicsConfiguration");
    private AbstractGraphicsScreen screen;
    protected CapabilitiesImmutable capabilitiesChosen;
    protected CapabilitiesImmutable capabilitiesRequested;

    public DefaultGraphicsConfiguration(AbstractGraphicsScreen abstractGraphicsScreen, CapabilitiesImmutable capabilitiesImmutable, CapabilitiesImmutable capabilitiesImmutable2) {
        if (null == abstractGraphicsScreen) {
            throw new IllegalArgumentException("Null screen");
        }
        if (null == capabilitiesImmutable) {
            throw new IllegalArgumentException("Null chosen caps");
        }
        if (null == capabilitiesImmutable2) {
            throw new IllegalArgumentException("Null requested caps");
        }
        this.screen = abstractGraphicsScreen;
        this.capabilitiesChosen = capabilitiesImmutable;
        this.capabilitiesRequested = capabilitiesImmutable2;
    }

    @Override
    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new NativeWindowException(cloneNotSupportedException);
        }
    }

    @Override
    public final AbstractGraphicsScreen getScreen() {
        return this.screen;
    }

    @Override
    public final CapabilitiesImmutable getChosenCapabilities() {
        return this.capabilitiesChosen;
    }

    @Override
    public final CapabilitiesImmutable getRequestedCapabilities() {
        return this.capabilitiesRequested;
    }

    @Override
    public AbstractGraphicsConfiguration getNativeGraphicsConfiguration() {
        return this;
    }

    @Override
    public final int getVisualID(VisualIDHolder.VIDType vIDType) throws NativeWindowException {
        return this.capabilitiesChosen.getVisualID(vIDType);
    }

    protected void setChosenCapabilities(CapabilitiesImmutable capabilitiesImmutable) {
        this.capabilitiesChosen = capabilitiesImmutable;
    }

    protected void setScreen(AbstractGraphicsScreen abstractGraphicsScreen) {
        this.screen = abstractGraphicsScreen;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + this.screen + ",\n\tchosen    " + this.capabilitiesChosen + ",\n\trequested " + this.capabilitiesRequested + "]";
    }

    public static String toHexString(int n2) {
        return "0x" + Integer.toHexString(n2);
    }

    public static String toHexString(long l2) {
        return "0x" + Long.toHexString(l2);
    }
}

