/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.graph.geom;

import com.jogamp.graph.geom.Vertex;
import com.jogamp.opengl.math.VectorUtil;

public class SVertex
implements Vertex {
    private int id;
    protected boolean onCurve;
    protected final float[] coord = new float[3];
    private final float[] texCoord = new float[3];
    static final Factory factory = new Factory();

    public static Factory factory() {
        return factory;
    }

    public SVertex() {
        this.id = Integer.MAX_VALUE;
    }

    public SVertex(Vertex vertex) {
        this.id = Integer.MAX_VALUE;
        System.arraycopy(vertex.getCoord(), 0, this.coord, 0, 3);
        System.arraycopy(vertex.getTexCoord(), 0, this.texCoord, 0, 3);
        this.setOnCurve(vertex.isOnCurve());
    }

    public SVertex(int n2, boolean bl, float[] fArray) {
        this.id = n2;
        this.onCurve = bl;
        System.arraycopy(fArray, 0, this.texCoord, 0, 3);
    }

    public SVertex(float f2, float f3, float f4, boolean bl) {
        this.id = Integer.MAX_VALUE;
        this.setCoord(f2, f3, f4);
        this.setOnCurve(bl);
    }

    public SVertex(float[] fArray, int n2, int n3, boolean bl) {
        this.id = Integer.MAX_VALUE;
        this.setCoord(fArray, n2, n3);
        this.setOnCurve(bl);
    }

    @Override
    public final void setCoord(float f2, float f3, float f4) {
        this.coord[0] = f2;
        this.coord[1] = f3;
        this.coord[2] = f4;
    }

    @Override
    public final void setCoord(float[] fArray, int n2, int n3) {
        System.arraycopy(fArray, n2, this.coord, 0, n3);
    }

    @Override
    public int getCoordCount() {
        return 3;
    }

    @Override
    public final float[] getCoord() {
        return this.coord;
    }

    @Override
    public final void setX(float f2) {
        this.coord[0] = f2;
    }

    @Override
    public final void setY(float f2) {
        this.coord[1] = f2;
    }

    @Override
    public final void setZ(float f2) {
        this.coord[2] = f2;
    }

    @Override
    public final float getX() {
        return this.coord[0];
    }

    @Override
    public final float getY() {
        return this.coord[1];
    }

    @Override
    public final float getZ() {
        return this.coord[2];
    }

    @Override
    public final boolean isOnCurve() {
        return this.onCurve;
    }

    @Override
    public final void setOnCurve(boolean bl) {
        this.onCurve = bl;
    }

    @Override
    public final int getId() {
        return this.id;
    }

    @Override
    public final void setId(int n2) {
        this.id = n2;
    }

    @Override
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (null == object || !(object instanceof Vertex)) {
            return false;
        }
        Vertex vertex = (Vertex)object;
        return this == vertex || this.isOnCurve() == vertex.isOnCurve() && VectorUtil.isVec3Equal(this.getTexCoord(), 0, vertex.getTexCoord(), 0, 1.1920929E-7f) && VectorUtil.isVec3Equal(this.getCoord(), 0, vertex.getCoord(), 0, 1.1920929E-7f);
    }

    public final int hashCode() {
        throw new InternalError("hashCode not designed");
    }

    @Override
    public final float[] getTexCoord() {
        return this.texCoord;
    }

    @Override
    public final void setTexCoord(float f2, float f3, float f4) {
        this.texCoord[0] = f2;
        this.texCoord[1] = f3;
        this.texCoord[2] = f4;
    }

    @Override
    public final void setTexCoord(float[] fArray, int n2, int n3) {
        System.arraycopy(fArray, n2, this.texCoord, 0, n3);
    }

    @Override
    public SVertex clone() {
        return new SVertex(this);
    }

    public String toString() {
        return "[ID: " + this.id + ", onCurve: " + this.onCurve + ": p " + this.coord[0] + ", " + this.coord[1] + ", " + this.coord[2] + ", t " + this.texCoord[0] + ", " + this.texCoord[1] + ", " + this.texCoord[2] + "]";
    }

    public static class Factory
    implements Vertex.Factory<SVertex> {
        @Override
        public SVertex create() {
            return new SVertex();
        }

        @Override
        public SVertex create(Vertex vertex) {
            return new SVertex(vertex);
        }

        @Override
        public SVertex create(int n2, boolean bl, float[] fArray) {
            return new SVertex(n2, bl, fArray);
        }

        @Override
        public SVertex create(float f2, float f3, float f4, boolean bl) {
            return new SVertex(f2, f3, f4, bl);
        }

        @Override
        public SVertex create(float[] fArray, int n2, int n3, boolean bl) {
            return new SVertex(fArray, n2, n3, bl);
        }
    }
}

