/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.graph.geom;

import com.jogamp.graph.geom.Vertex;
import com.jogamp.opengl.math.FloatUtil;
import com.jogamp.opengl.math.VectorUtil;
import com.jogamp.opengl.math.geom.AABBox;
import java.util.ArrayList;
import jogamp.graph.geom.plane.AffineTransform;

public class Outline
implements Comparable<Outline> {
    private ArrayList<Vertex> vertices;
    private boolean closed;
    private final AABBox bbox;
    private boolean dirtyBBox;

    public Outline() {
        this.vertices = new ArrayList(3);
        this.closed = false;
        this.bbox = new AABBox();
        this.dirtyBBox = false;
    }

    public Outline(Outline outline) {
        this.vertices = new ArrayList(outline.vertices.size());
        for (int i2 = 0; i2 < this.vertices.size(); ++i2) {
            this.vertices.add(outline.vertices.get(i2).clone());
        }
        this.closed = outline.closed;
        this.bbox = new AABBox(outline.bbox);
        this.dirtyBBox = outline.dirtyBBox;
    }

    public final int getVertexCount() {
        return this.vertices.size();
    }

    public final void addVertex(Vertex vertex) throws NullPointerException {
        this.addVertex(this.vertices.size(), vertex);
    }

    public final void addVertex(int n2, Vertex vertex) throws NullPointerException, IndexOutOfBoundsException {
        if (null == vertex) {
            throw new NullPointerException("vertex is null");
        }
        this.vertices.add(n2, vertex);
        if (!this.dirtyBBox) {
            this.bbox.resize(vertex.getCoord());
        }
    }

    public final void setVertex(int n2, Vertex vertex) throws NullPointerException, IndexOutOfBoundsException {
        if (null == vertex) {
            throw new NullPointerException("vertex is null");
        }
        this.vertices.set(n2, vertex);
        this.dirtyBBox = true;
    }

    public final Vertex getVertex(int n2) {
        return this.vertices.get(n2);
    }

    public int getVertexIndex(Vertex vertex) {
        return this.vertices.indexOf(vertex);
    }

    public final Vertex removeVertex(int n2) throws IndexOutOfBoundsException {
        this.dirtyBBox = true;
        return this.vertices.remove(n2);
    }

    public final boolean isEmpty() {
        return this.vertices.size() == 0;
    }

    public final Vertex getLastVertex() {
        if (this.isEmpty()) {
            return null;
        }
        return this.vertices.get(this.vertices.size() - 1);
    }

    public final ArrayList<Vertex> getVertices() {
        return this.vertices;
    }

    public final void setVertices(ArrayList<Vertex> arrayList) {
        this.vertices = arrayList;
        this.validateBoundingBox();
    }

    public final boolean isClosed() {
        return this.closed;
    }

    public final boolean setClosed(boolean bl) {
        this.closed = true;
        if (!this.isEmpty()) {
            Vertex vertex = this.vertices.get(0);
            Vertex vertex2 = this.getLastVertex();
            if (!VectorUtil.isVec3Equal(vertex.getCoord(), 0, vertex2.getCoord(), 0, 1.1920929E-7f)) {
                if (bl) {
                    this.vertices.add(vertex.clone());
                } else {
                    this.vertices.add(0, vertex2.clone());
                }
                return true;
            }
        }
        return false;
    }

    public final Outline transform(AffineTransform affineTransform, Vertex.Factory<? extends Vertex> factory) {
        Outline outline = new Outline();
        int n2 = this.vertices.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            Vertex vertex = this.vertices.get(i2);
            outline.addVertex(affineTransform.transform(vertex, factory.create()));
        }
        outline.closed = this.closed;
        return outline;
    }

    private final void validateBoundingBox() {
        this.dirtyBBox = false;
        this.bbox.reset();
        for (int i2 = 0; i2 < this.vertices.size(); ++i2) {
            this.bbox.resize(this.vertices.get(i2).getCoord());
        }
    }

    public final AABBox getBounds() {
        if (this.dirtyBBox) {
            this.validateBoundingBox();
        }
        return this.bbox;
    }

    @Override
    public final int compareTo(Outline outline) {
        float f2;
        float f3 = this.getBounds().getSize();
        if (FloatUtil.isEqual(f3, f2 = outline.getBounds().getSize(), 1.1920929E-7f)) {
            return 0;
        }
        if (f3 < f2) {
            return -1;
        }
        return 1;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (null == object || !(object instanceof Outline)) {
            return false;
        }
        Outline outline = (Outline)object;
        if (this.getVertexCount() != outline.getVertexCount()) {
            return false;
        }
        if (!this.getBounds().equals(outline.getBounds())) {
            return false;
        }
        for (int i2 = this.getVertexCount() - 1; i2 >= 0; --i2) {
            if (this.getVertex(i2).equals(outline.getVertex(i2))) continue;
            return false;
        }
        return true;
    }

    public final int hashCode() {
        throw new InternalError("hashCode not designed");
    }

    public String toString() {
        return this.getClass().getName() + "@" + Integer.toHexString(super.hashCode());
    }
}

