/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.graph.curve;

import com.jogamp.graph.curve.OutlineShape;
import com.jogamp.graph.geom.Triangle;
import com.jogamp.graph.geom.Vertex;
import com.jogamp.opengl.math.geom.AABBox;
import com.jogamp.opengl.math.geom.Frustum;
import java.util.ArrayList;
import java.util.List;
import jogamp.graph.geom.plane.AffineTransform;
import jogamp.opengl.Debug;

public abstract class Region {
    public static final boolean DEBUG = Debug.debug("graph.curve");
    public static final boolean DEBUG_INSTANCE = Debug.debug("graph.curve.Instance");
    public static final int MSAA_RENDERING_BIT = 1;
    public static final int VBAA_RENDERING_BIT = 2;
    public static final int VARWEIGHT_RENDERING_BIT = 256;
    public static final int COLORCHANNEL_RENDERING_BIT = 512;
    public static final int COLORTEXTURE_RENDERING_BIT = 1024;
    public static final int MAX_QUALITY = 1;
    public static final int DEFAULT_TWO_PASS_TEXTURE_UNIT = 0;
    protected static final int DIRTY_SHAPE = 1;
    protected static final int DIRTY_STATE = 2;
    private final int renderModes;
    private int quality;
    private int dirty = 3;
    private int numVertices = 0;
    protected final AABBox box = new AABBox();
    protected Frustum frustum = null;
    final float[] coordsEx = new float[3];
    private final AABBox tmpBox = new AABBox();

    public static boolean isVBAA(int n2) {
        return 0 != (n2 & 2);
    }

    public static boolean isMSAA(int n2) {
        return 0 != (n2 & 1);
    }

    public static boolean isTwoPass(int n2) {
        return 0 != (n2 & 3);
    }

    public static boolean hasVariableWeight(int n2) {
        return 0 != (n2 & 0x100);
    }

    public static boolean hasColorChannel(int n2) {
        return 0 != (n2 & 0x200);
    }

    public static boolean hasColorTexture(int n2) {
        return 0 != (n2 & 0x400);
    }

    public static String getRenderModeString(int n2) {
        String string;
        String string2 = Region.hasVariableWeight(n2) ? "-curve" : "";
        String string3 = Region.hasColorChannel(n2) ? "-cols" : "";
        String string4 = string = Region.hasColorTexture(n2) ? "-ctex" : "";
        if (Region.isVBAA(n2)) {
            return "vbaa" + string2 + string3 + string;
        }
        if (Region.isMSAA(n2)) {
            return "msaa" + string2 + string3 + string;
        }
        return "norm" + string2 + string3 + string;
    }

    protected Region(int n2) {
        this.renderModes = n2;
        this.quality = 1;
    }

    protected abstract void pushVertex(float[] var1, float[] var2, float[] var3);

    protected abstract void pushIndex(int var1);

    public final int getRenderModes() {
        return this.renderModes;
    }

    public final int getQuality() {
        return this.quality;
    }

    public final void setQuality(int n2) {
        this.quality = n2;
    }

    protected void clearImpl() {
        this.dirty = 3;
        this.numVertices = 0;
        this.box.reset();
    }

    public final boolean isVBAA() {
        return Region.isVBAA(this.renderModes);
    }

    public final boolean isMSAA() {
        return Region.isMSAA(this.renderModes);
    }

    public final boolean hasVariableWeight() {
        return Region.hasVariableWeight(this.renderModes);
    }

    public boolean hasColorChannel() {
        return Region.hasColorChannel(this.renderModes);
    }

    public boolean hasColorTexture() {
        return Region.hasColorTexture(this.renderModes);
    }

    public final Frustum getFrustum() {
        return this.frustum;
    }

    public final void setFrustum(Frustum frustum) {
        this.frustum = frustum;
    }

    private void pushNewVertexImpl(Vertex vertex, AffineTransform affineTransform, float[] fArray) {
        if (null != affineTransform) {
            float[] fArray2 = vertex.getCoord();
            affineTransform.transform(fArray2, this.coordsEx);
            this.coordsEx[2] = fArray2[2];
            this.box.resize(this.coordsEx[0], this.coordsEx[1], this.coordsEx[2]);
            this.pushVertex(this.coordsEx, vertex.getTexCoord(), fArray);
        } else {
            this.box.resize(vertex.getX(), vertex.getY(), vertex.getZ());
            this.pushVertex(vertex.getCoord(), vertex.getTexCoord(), fArray);
        }
        ++this.numVertices;
    }

    private void pushNewVertexIdxImpl(Vertex vertex, AffineTransform affineTransform, float[] fArray) {
        this.pushIndex(this.numVertices);
        this.pushNewVertexImpl(vertex, affineTransform, fArray);
    }

    public final void addOutlineShape(OutlineShape outlineShape, AffineTransform affineTransform, float[] fArray) {
        int n2;
        int n3;
        int n4;
        Object object;
        Object object2;
        if (null != this.frustum) {
            object2 = outlineShape.getBounds();
            if (null != affineTransform) {
                affineTransform.transform((AABBox)object2, this.tmpBox);
                object = this.tmpBox;
            } else {
                object = object2;
            }
            if (this.frustum.isAABBoxOutside((AABBox)object)) {
                if (DEBUG_INSTANCE) {
                    System.err.println("Region.addOutlineShape(): Dropping outside shapeBoxT: " + object);
                }
                return;
            }
        }
        object2 = outlineShape.getTriangles(OutlineShape.VerticesState.QUADRATIC_NURBS);
        object = outlineShape.getVertices();
        if (DEBUG_INSTANCE) {
            n4 = outlineShape.getAddedVerticeCount();
            n3 = ((ArrayList)object).size() + n4;
            n2 = object2.size() * 3;
            System.err.println("Region.addOutlineShape().0: tris: " + object2.size() + ", verts " + ((ArrayList)object).size() + ", transform " + affineTransform);
            System.err.println("Region.addOutlineShape().0: VerticeCount " + ((ArrayList)object).size() + " + " + n4 + " = " + n3);
            System.err.println("Region.addOutlineShape().0: IndexCount " + n2);
        }
        n4 = this.numVertices;
        n3 = 0;
        n2 = 0;
        int n5 = 0;
        int n6 = 0;
        if (((ArrayList)object).size() >= 3) {
            int n7;
            if (DEBUG_INSTANCE) {
                System.err.println("Region.addOutlineShape(): Processing Vertices");
            }
            for (n7 = 0; n7 < ((ArrayList)object).size(); ++n7) {
                this.pushNewVertexImpl((Vertex)((ArrayList)object).get(n7), affineTransform, fArray);
                ++n3;
            }
            if (DEBUG_INSTANCE) {
                System.err.println("Region.addOutlineShape(): Processing Triangles");
            }
            for (n7 = 0; n7 < object2.size(); ++n7) {
                Vertex[] vertexArray;
                int n8;
                Triangle triangle = (Triangle)object2.get(n7);
                if (DEBUG_INSTANCE) {
                    System.err.println("T[" + n7 + "]: " + triangle);
                }
                if (Integer.MAX_VALUE - n4 > (n8 = (vertexArray = triangle.getVertices())[0].getId())) {
                    if (DEBUG_INSTANCE) {
                        System.err.println("T[" + n7 + "]: Moved " + n8 + " + " + n4 + " -> " + (n8 + n4));
                    }
                    this.pushIndex(n8 + n4);
                    this.pushIndex(vertexArray[1].getId() + n4);
                    this.pushIndex(vertexArray[2].getId() + n4);
                    n2 += 3;
                } else {
                    if (DEBUG_INSTANCE) {
                        System.err.println("T[" + n7 + "]: New Idx " + this.numVertices);
                    }
                    this.pushNewVertexIdxImpl(vertexArray[0], affineTransform, fArray);
                    this.pushNewVertexIdxImpl(vertexArray[1], affineTransform, fArray);
                    this.pushNewVertexIdxImpl(vertexArray[2], affineTransform, fArray);
                    n5 += 3;
                }
                ++n6;
            }
        }
        if (DEBUG_INSTANCE) {
            System.err.println("Region.addOutlineShape().X: idxOffset " + n4 + ", tris: " + n6 + ", verts [idx " + n5 + ", add " + n5 + " = " + (n3 + n5) + "]");
            System.err.println("Region.addOutlineShape().X: verts: idx[v-new " + n3 + ", t-new " + n5 + " = " + (n3 + n5) + "]");
            System.err.println("Region.addOutlineShape().X: verts: idx t-moved " + n2 + ", numVertices " + this.numVertices);
            System.err.println("Region.addOutlineShape().X: verts: v-dups 0, t-dups 0, t-known 0");
            System.err.println("Region.addOutlineShape().X: box " + this.box);
        }
        this.markShapeDirty();
    }

    public final void addOutlineShapes(List<OutlineShape> list, AffineTransform affineTransform, float[] fArray) {
        for (int i2 = 0; i2 < list.size(); ++i2) {
            this.addOutlineShape(list.get(i2), affineTransform, fArray);
        }
    }

    public final AABBox getBounds() {
        return this.box;
    }

    public final void markShapeDirty() {
        this.dirty |= 1;
    }

    public final boolean isShapeDirty() {
        return 0 != (this.dirty & 1);
    }

    public final void markStateDirty() {
        this.dirty |= 2;
    }

    public final boolean isStateDirty() {
        return 0 != (this.dirty & 2);
    }

    protected final void clearDirtyBits(int n2) {
        this.dirty &= ~n2;
    }

    protected final int getDirtyBits() {
        return this.dirty;
    }

    public String toString() {
        return "Region[" + Region.getRenderModeString(this.renderModes) + ", q " + this.quality + ", dirty " + this.dirty + ", vertices " + this.numVertices + ", box " + this.box + "]";
    }
}

