/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.common.util;

import com.jogamp.common.util.PrimitiveStack;
import java.nio.BufferOverflowException;
import java.nio.BufferUnderflowException;
import java.nio.IntBuffer;

public class IntegerStack
implements PrimitiveStack {
    private int position = 0;
    private int[] buffer;
    private int growSize;

    public IntegerStack(int n2, int n3) {
        this.growSize = n3;
        this.buffer = new int[n2];
    }

    @Override
    public final int capacity() {
        return this.buffer.length;
    }

    @Override
    public final int position() {
        return this.position;
    }

    @Override
    public final void position(int n2) throws IndexOutOfBoundsException {
        if (0 > this.position || this.position >= this.buffer.length) {
            throw new IndexOutOfBoundsException("Invalid new position " + n2 + ", " + this.toString());
        }
        this.position = n2;
    }

    @Override
    public final int remaining() {
        return this.buffer.length - this.position;
    }

    @Override
    public final int getGrowSize() {
        return this.growSize;
    }

    @Override
    public final void setGrowSize(int n2) {
        this.growSize = n2;
    }

    public final String toString() {
        return "IntegerStack[0..(pos " + this.position + ").." + this.buffer.length + ", remaining " + this.remaining() + "]";
    }

    public final int[] buffer() {
        return this.buffer;
    }

    private final void growIfNecessary(int n2) throws IndexOutOfBoundsException {
        if (this.position + n2 > this.buffer.length) {
            if (0 >= this.growSize) {
                throw new IndexOutOfBoundsException("Out of fixed stack size: " + this);
            }
            int[] nArray = new int[this.buffer.length + this.growSize];
            System.arraycopy(this.buffer, 0, nArray, 0, this.position);
            this.buffer = nArray;
        }
    }

    public final int[] putOnTop(int[] nArray, int n2, int n3) throws IndexOutOfBoundsException {
        this.growIfNecessary(n3);
        System.arraycopy(nArray, n2, this.buffer, this.position, n3);
        this.position += n3;
        return nArray;
    }

    public final IntBuffer putOnTop(IntBuffer intBuffer, int n2) throws IndexOutOfBoundsException, BufferUnderflowException {
        this.growIfNecessary(n2);
        intBuffer.get(this.buffer, this.position, n2);
        this.position += n2;
        return intBuffer;
    }

    public final int[] getFromTop(int[] nArray, int n2, int n3) throws IndexOutOfBoundsException {
        System.arraycopy(this.buffer, this.position - n3, nArray, n2, n3);
        this.position -= n3;
        return nArray;
    }

    public final IntBuffer getFromTop(IntBuffer intBuffer, int n2) throws IndexOutOfBoundsException, BufferOverflowException {
        intBuffer.put(this.buffer, this.position - n2, n2);
        this.position -= n2;
        return intBuffer;
    }
}

