/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.common.util;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.zip.DataFormatException;
import java.util.zip.Deflater;
import java.util.zip.Inflater;

public class CustomCompress {
    public static final int MAGIC = -554588192;

    public static byte[] inflateFromStream(InputStream inputStream) throws IOException, ArrayIndexOutOfBoundsException, IllegalArgumentException {
        DataInputStream dataInputStream = new DataInputStream(inputStream);
        int n2 = dataInputStream.readInt();
        if (n2 != -554588192) {
            throw new IOException("wrong magic: " + Integer.toHexString(n2) + ", expected " + Integer.toHexString(-554588192));
        }
        int n3 = dataInputStream.readInt();
        int n4 = dataInputStream.readInt();
        return CustomCompress.inflateFromStream(inputStream, n3, n4, new byte[n4], 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] inflateFromStream(InputStream inputStream, int n2, int n3, byte[] byArray, int n4) throws IOException, ArrayIndexOutOfBoundsException, IllegalArgumentException {
        int n5;
        if (n2 <= 0 || n3 <= 0) {
            throw new IllegalArgumentException("Length[input " + n2 + ", output " + n3 + "]");
        }
        if (n4 < 0 || byArray.length < n4 + n3) {
            throw new ArrayIndexOutOfBoundsException("output.length " + byArray.length + ", offset " + n4 + ", length " + n3);
        }
        byte[] byArray2 = new byte[n2];
        int n6 = 0;
        try {
            int n7;
            while (0 < (n7 = n2 - n6)) {
                n5 = inputStream.read(byArray2, n6, n7);
                if (n5 == -1) {
                    break;
                }
                n6 += n5;
            }
        }
        finally {
            inputStream.close();
        }
        if (n2 != n6) {
            throw new IOException("Got " + n6 + " bytes != expected " + n2);
        }
        try {
            Inflater inflater = new Inflater();
            inflater.setInput(byArray2, 0, n2);
            n5 = inflater.inflate(byArray, n4, n3);
            inflater.end();
            if (n3 != n5) {
                throw new IOException("Got inflated " + n5 + " bytes != expected " + n3);
            }
        }
        catch (DataFormatException dataFormatException) {
            throw new IOException(dataFormatException);
        }
        return byArray;
    }

    public static int deflateToStream(byte[] byArray, int n2, int n3, int n4, OutputStream outputStream) throws IOException, ArrayIndexOutOfBoundsException, IllegalArgumentException {
        if (n3 <= 0) {
            throw new IllegalArgumentException("Length[input " + n3 + "]");
        }
        if (n2 < 0 || byArray.length < n2 + n3) {
            throw new ArrayIndexOutOfBoundsException("input.length " + byArray.length + ", offset " + n2 + ", length " + n3);
        }
        byte[] byArray2 = new byte[n3];
        Deflater deflater = new Deflater(n4);
        deflater.setInput(byArray, n2, n3);
        deflater.finish();
        int n5 = deflater.deflate(byArray2, 0, n3);
        deflater.end();
        DataOutputStream dataOutputStream = new DataOutputStream(outputStream);
        dataOutputStream.writeInt(-554588192);
        dataOutputStream.writeInt(n5);
        dataOutputStream.writeInt(n3);
        outputStream.write(byArray2, 0, n5);
        return n5;
    }
}

