/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.common.nio;

import com.jogamp.common.nio.Buffers;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.DoubleBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.nio.LongBuffer;
import java.nio.ShortBuffer;

public class CachedBufferFactory {
    public static final int DEFAULT_ALLOCATION_SIZE = 0x100000;
    private final int ALLOCATION_SIZE;
    private ByteBuffer currentBuffer;

    private CachedBufferFactory() {
        this(0x100000, 0x100000);
    }

    private CachedBufferFactory(int n2, int n3) {
        this.currentBuffer = Buffers.newDirectByteBuffer(n2);
        this.ALLOCATION_SIZE = n3;
    }

    public static CachedBufferFactory create() {
        return new CachedBufferFactory();
    }

    public static CachedBufferFactory create(int n2) {
        return new CachedBufferFactory(n2, 0x100000);
    }

    public static CachedBufferFactory create(int n2, boolean bl) {
        return new CachedBufferFactory(n2, bl ? -1 : 0x100000);
    }

    public static CachedBufferFactory create(int n2, int n3) {
        return new CachedBufferFactory(n2, n3);
    }

    public static CachedBufferFactory createSynchronized() {
        return new SynchronizedCachedBufferFactory();
    }

    public static CachedBufferFactory createSynchronized(int n2) {
        return new SynchronizedCachedBufferFactory(n2, 0x100000);
    }

    public static CachedBufferFactory createSynchronized(int n2, boolean bl) {
        return new SynchronizedCachedBufferFactory(n2, bl ? -1 : 0x100000);
    }

    public static CachedBufferFactory createSynchronized(int n2, int n3) {
        return new CachedBufferFactory(n2, n3);
    }

    public boolean isFixed() {
        return this.ALLOCATION_SIZE == -1;
    }

    public int getAllocationSize() {
        return this.ALLOCATION_SIZE;
    }

    private void checkIfFixed() {
        if (this.ALLOCATION_SIZE == 0) {
            throw new RuntimeException("fixed size buffer factory ran out ouf bounds.");
        }
    }

    public void destroy() {
        if (null != this.currentBuffer) {
            this.currentBuffer.clear();
            this.currentBuffer = null;
        }
    }

    public ByteBuffer newDirectByteBuffer(int n2) {
        if (n2 > this.currentBuffer.capacity()) {
            this.checkIfFixed();
            return Buffers.newDirectByteBuffer(n2);
        }
        if (n2 > this.currentBuffer.remaining()) {
            this.checkIfFixed();
            this.currentBuffer = Buffers.newDirectByteBuffer(this.ALLOCATION_SIZE);
        }
        this.currentBuffer.limit(this.currentBuffer.position() + n2);
        ByteBuffer byteBuffer = this.currentBuffer.slice().order(this.currentBuffer.order());
        this.currentBuffer.position(this.currentBuffer.limit());
        this.currentBuffer.limit(this.currentBuffer.capacity());
        return byteBuffer;
    }

    public ByteBuffer newDirectByteBuffer(byte[] byArray, int n2, int n3) {
        return (ByteBuffer)this.newDirectByteBuffer(n3).put(byArray, n2, n3).rewind();
    }

    public ByteBuffer newDirectByteBuffer(byte[] byArray, int n2) {
        return this.newDirectByteBuffer(byArray, n2, byArray.length - n2);
    }

    public ByteBuffer newDirectByteBuffer(byte[] byArray) {
        return this.newDirectByteBuffer(byArray, 0);
    }

    public DoubleBuffer newDirectDoubleBuffer(int n2) {
        return this.newDirectByteBuffer(n2 * 8).asDoubleBuffer();
    }

    public DoubleBuffer newDirectDoubleBuffer(double[] dArray, int n2, int n3) {
        return (DoubleBuffer)this.newDirectDoubleBuffer(n3).put(dArray, n2, n3).rewind();
    }

    public DoubleBuffer newDirectDoubleBuffer(double[] dArray, int n2) {
        return this.newDirectDoubleBuffer(dArray, n2, dArray.length - n2);
    }

    public DoubleBuffer newDirectDoubleBuffer(double[] dArray) {
        return this.newDirectDoubleBuffer(dArray, 0);
    }

    public FloatBuffer newDirectFloatBuffer(int n2) {
        return this.newDirectByteBuffer(n2 * 4).asFloatBuffer();
    }

    public FloatBuffer newDirectFloatBuffer(float[] fArray, int n2, int n3) {
        return (FloatBuffer)this.newDirectFloatBuffer(n3).put(fArray, n2, n3).rewind();
    }

    public FloatBuffer newDirectFloatBuffer(float[] fArray, int n2) {
        return this.newDirectFloatBuffer(fArray, n2, fArray.length - n2);
    }

    public FloatBuffer newDirectFloatBuffer(float[] fArray) {
        return this.newDirectFloatBuffer(fArray, 0);
    }

    public IntBuffer newDirectIntBuffer(int n2) {
        return this.newDirectByteBuffer(n2 * 4).asIntBuffer();
    }

    public IntBuffer newDirectIntBuffer(int[] nArray, int n2, int n3) {
        return (IntBuffer)this.newDirectIntBuffer(n3).put(nArray, n2, n3).rewind();
    }

    public IntBuffer newDirectIntBuffer(int[] nArray, int n2) {
        return this.newDirectIntBuffer(nArray, n2, nArray.length - n2);
    }

    public IntBuffer newDirectIntBuffer(int[] nArray) {
        return this.newDirectIntBuffer(nArray, 0);
    }

    public LongBuffer newDirectLongBuffer(int n2) {
        return this.newDirectByteBuffer(n2 * 8).asLongBuffer();
    }

    public LongBuffer newDirectLongBuffer(long[] lArray, int n2, int n3) {
        return (LongBuffer)this.newDirectLongBuffer(n3).put(lArray, n2, n3).rewind();
    }

    public LongBuffer newDirectLongBuffer(long[] lArray, int n2) {
        return this.newDirectLongBuffer(lArray, n2, lArray.length - n2);
    }

    public LongBuffer newDirectLongBuffer(long[] lArray) {
        return this.newDirectLongBuffer(lArray, 0);
    }

    public ShortBuffer newDirectShortBuffer(int n2) {
        return this.newDirectByteBuffer(n2 * 2).asShortBuffer();
    }

    public ShortBuffer newDirectShortBuffer(short[] sArray, int n2, int n3) {
        return (ShortBuffer)this.newDirectShortBuffer(n3).put(sArray, n2, n3).rewind();
    }

    public ShortBuffer newDirectShortBuffer(short[] sArray, int n2) {
        return this.newDirectShortBuffer(sArray, n2, sArray.length - n2);
    }

    public ShortBuffer newDirectShortBuffer(short[] sArray) {
        return this.newDirectShortBuffer(sArray, 0);
    }

    public CharBuffer newDirectCharBuffer(int n2) {
        return this.newDirectByteBuffer(n2 * 2).asCharBuffer();
    }

    public CharBuffer newDirectCharBuffer(char[] cArray, int n2, int n3) {
        return (CharBuffer)this.newDirectCharBuffer(n3).put(cArray, n2, n3).rewind();
    }

    public CharBuffer newDirectCharBuffer(char[] cArray, int n2) {
        return this.newDirectCharBuffer(cArray, n2, cArray.length - n2);
    }

    public CharBuffer newDirectCharBuffer(char[] cArray) {
        return this.newDirectCharBuffer(cArray, 0);
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        CachedBufferFactory cachedBufferFactory = (CachedBufferFactory)object;
        if (this.ALLOCATION_SIZE != cachedBufferFactory.ALLOCATION_SIZE) {
            return false;
        }
        return this.currentBuffer == cachedBufferFactory.currentBuffer || this.currentBuffer != null && this.currentBuffer.equals(cachedBufferFactory.currentBuffer);
    }

    public String toString() {
        return this.getClass().getName() + "[static:" + this.isFixed() + " alloc size:" + this.getAllocationSize() + "]";
    }

    private static class SynchronizedCachedBufferFactory
    extends CachedBufferFactory {
        private SynchronizedCachedBufferFactory() {
        }

        private SynchronizedCachedBufferFactory(int n2, int n3) {
            super(n2, n3);
        }

        @Override
        public synchronized ByteBuffer newDirectByteBuffer(int n2) {
            return super.newDirectByteBuffer(n2);
        }
    }
}

