/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.common.net;

import com.jogamp.common.net.Uri;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class UriQueryProps {
    private static final String QMARK = "?";
    private static final char ASSIG = '=';
    private static final String EMPTY = "";
    private final String query_separator;
    private final HashMap<String, String> properties = new HashMap();

    private UriQueryProps(char c2) {
        this.query_separator = String.valueOf(c2);
    }

    public final Map<String, String> getProperties() {
        return this.properties;
    }

    public final char getQuerySeparator() {
        return this.query_separator.charAt(0);
    }

    public final Uri.Encoded appendQuery(Uri.Encoded encoded) {
        boolean bl = false;
        StringBuilder stringBuilder = new StringBuilder();
        if (null != encoded) {
            if (encoded.startsWith(QMARK)) {
                encoded = encoded.substring(1);
            }
            stringBuilder.append(encoded.get());
            if (!encoded.endsWith(this.query_separator)) {
                bl = true;
            }
        }
        Iterator<Map.Entry<String, String>> iterator = this.properties.entrySet().iterator();
        while (iterator.hasNext()) {
            if (bl) {
                stringBuilder.append(this.query_separator);
            }
            Map.Entry<String, String> entry = iterator.next();
            stringBuilder.append(entry.getKey());
            if (EMPTY != entry.getValue()) {
                stringBuilder.append('=').append(entry.getValue());
            }
            bl = true;
        }
        return new Uri.Encoded(stringBuilder.toString(), "_-.~,;:$&+=!*'()@/?[]\\\"");
    }

    public final Uri appendQuery(Uri uri) throws URISyntaxException {
        return uri.getNewQuery(this.appendQuery(uri.query));
    }

    public static final UriQueryProps create(Uri uri, char c2) throws IllegalArgumentException {
        if (';' != c2 && '&' != c2) {
            throw new IllegalArgumentException("querySeparator is invalid: " + c2);
        }
        UriQueryProps uriQueryProps = new UriQueryProps(c2);
        String string = Uri.decode(uri.query);
        int n2 = null != string ? string.length() : -1;
        int n3 = -1;
        while (n3 < n2) {
            String string2;
            int n4;
            int n5 = n3 + 1;
            if (0 == (n3 = string.indexOf(c2, n5))) continue;
            if (0 > n3) {
                n3 = n2;
            }
            if (0 < (n4 = (string2 = string.substring(n5, n3)).indexOf(61))) {
                String string3 = string2.substring(0, n4);
                String string4 = string2.substring(n4 + 1);
                uriQueryProps.properties.put(string3, string4);
                continue;
            }
            uriQueryProps.properties.put(string2, EMPTY);
        }
        return uriQueryProps;
    }
}

