/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.common;

import java.io.PrintStream;

public class ExceptionUtils {
    public static void dumpStack(PrintStream printStream) {
        ExceptionUtils.dumpStack(printStream, 1, -1);
    }

    public static void dumpStack(PrintStream printStream, int n2, int n3) {
        ExceptionUtils.dumpStack(printStream, new Exception(""), n2 + 1, n3);
    }

    public static void dumpStack(PrintStream printStream, Throwable throwable, int n2, int n3) {
        ExceptionUtils.dumpStack(printStream, throwable.getStackTrace(), n2, n3);
    }

    public static void dumpStack(PrintStream printStream, StackTraceElement[] stackTraceElementArray, int n2, int n3) {
        if (null == stackTraceElementArray) {
            return;
        }
        int n4 = 0 > n3 ? stackTraceElementArray.length : Math.min(n3 + n2, stackTraceElementArray.length);
        for (int i2 = n2; i2 < n4; ++i2) {
            printStream.println("    [" + i2 + "]: " + stackTraceElementArray[i2]);
        }
    }

    public static int printCause(PrintStream printStream, String string, Throwable throwable, int n2, int n3, int n4) {
        int n5;
        for (n5 = n2; null != throwable && (-1 == n3 || n5 < n3); ++n5, throwable = throwable.getCause()) {
            if (throwable instanceof CustomStackTrace) {
                ((CustomStackTrace)((Object)throwable)).printCauseStack(printStream, string, n5, n4);
                continue;
            }
            printStream.println(string + "[" + n5 + "] by " + throwable.getClass().getSimpleName() + ": " + throwable.getMessage() + " on thread " + Thread.currentThread().getName());
            ExceptionUtils.dumpStack(printStream, throwable.getStackTrace(), 0, n4);
        }
        return n5;
    }

    public static void printStackTrace(PrintStream printStream, Throwable throwable, int n2, int n3) {
        if (throwable instanceof CustomStackTrace) {
            ((CustomStackTrace)((Object)throwable)).printStackTrace(printStream, n2, n3);
        } else {
            printStream.println(throwable.getClass().getSimpleName() + ": " + throwable.getMessage() + " on thread " + Thread.currentThread().getName());
            ExceptionUtils.dumpStack(printStream, throwable.getStackTrace(), 0, n3);
            ExceptionUtils.printCause(printStream, "Caused", throwable.getCause(), 0, n2, n3);
        }
    }

    public static void dumpThrowable(String string, Throwable throwable) {
        ExceptionUtils.dumpThrowable(string, throwable, -1, -1);
    }

    public static void dumpThrowable(String string, Throwable throwable, int n2, int n3) {
        System.err.print("Caught " + string + " ");
        ExceptionUtils.printStackTrace(System.err, throwable, n2, n3);
    }

    public static interface CustomStackTrace {
        public void printCauseStack(PrintStream var1, String var2, int var3, int var4);

        public void printStackTrace(PrintStream var1, int var2, int var3);
    }
}

